// TextWindow.js

// Last updated: 03/12/10 //

var WinBg = 0;
var window = LoadWindowStyle("Window.rws");

function TextWindow(x, y, w, h, txt, background)
{
	Player.showLives = false;
	var arrow = new Arrow();
	WinBg = GrabImage(0,0,SW,SH);
	OpenWindow(x,y,w,h,500,background);
	for (var i = 0; i < txt.length; ++i) {
		if(!background) { UpdateMapEngine(); RenderMap(); }
		else TextPreRender();
		window.drawWindow(x, y, w, h);
		font.drawTextBox(x+2, y+2, w-4, h-4, 0, txt.substr(0, i));
		FlipScreen();
	}

	while(!IsKeyPressed(KEY_CTRL)) {
		if(!background) { UpdateMapEngine(); RenderMap(); }
		else TextPreRender();
		window.drawWindow(x, y, w, h);
		font.drawTextBox(x+2, y+2, w-4, h-4, 0, txt);
		arrow.blit(x+w/2-8,y+h-4);
		FlipScreen();
	}

	if(!background) { UpdateMapEngine(); RenderMap(); }
	else TextPreRender();

	window.drawWindow(x, y, w, h);
	font.drawTextBox(x+4, y, w, h, 0, txt);
	Player.showLives = true;
}

function OpenWindow(x, y, w, h, ms, background)
{
	var time = GetTime();
	while (GetTime() - time < ms) {
		var i = (GetTime() - time) * w / ms;
		if(!background) {
			if(IsMapEngineRunning()) { UpdateMapEngine(); RenderMap(); }
			else WinBg.blit(0,0);
		}
		else TextPreRender();
		window.drawWindow(x+w/2-i/2,y,i,h);
		FlipScreen();
	}
}

function TextPreRender()
{
	if(SpecialFX) {
		if(BG3.fadev <= 0) BG3.newFade = 255;
		if(BG3.fadev >= 255) BG3.newFade = 0;
		if(BG4.fadev <= 0) BG4.newFade = 255;
		if(BG4.fadev >= 255) BG4.newFade = 0;
	}

	BG3.blit(0,0);
	if(SpecialFX) {
		BG4.blit(0,0);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
	}

	Overhead.blit(0,0);
	Radnen.blit(8,SH-Radnen.img.height-4);
}

function Arrow()
{
	this.img = LoadImage("Arrow.png");
	this.y2 = 0;
	this.slide = 1;
}

Arrow.prototype.blit = function(x,y)
{
	with(this) {
		if (slide) {
			y2--; if (y2 == -4) slide = 0;
		}
		else {
			y2++; if (y2 == 4) slide = 1;
		}
		img.blit(x,y+y2);
	}
}